// Michael R. Hansen   2-11-2023
// Structural tests cases for routeOf
module Tests

open System
open Xunit
open Luggage



let r0 = [("l0","a0")]
let r1 = [("l0","a0"); ("l1","a1")]
let r2 = [("l0","a0"); ("l1","a1"); ("l2","a2")]


[<Fact>]
let ``B: non-empty cat, lid found immediately`` () =
    Assert.True(routeOf "l0" [("l0",r0)] = Some r0)

[<Fact>]
let ``C: non-empty cat, lid not found`` () =
    Assert.True(routeOf "l4" [("l0",r0)] = None)


[<Fact>]
let ``D: more than one element cat, lid found`` () =
    Assert.True(routeOf "l2" [ ("l0",r0);("l1",r1);("l2",r2)] = Some r2)

