module Tests

open System
open Xunit
open Luggage

open FsCheck
open FsCheck.Xunit
open LuggageCatalogueGenerator

[<Properties(Arbitrary = [| typeof<MyLuggageGenerator> |])>]

type ``PBT``() = 

   [<Property>]
   let ``Luggage with flight simple``(lc:LuggageCatalogue) = 
      let b = List.forall (fun (lid,r) -> 
                            List.forall (fun (f,_) -> List.contains lid (withFlight f lc)) r
                          )  lc
      Assert.True b

   [<Property>]
   let ``Luggage with flights``(lc:LuggageCatalogue) = 
      let b = List.forall (fun (lid,_) -> 
                            List.forall (fun f -> List.contains lid (withFlight f lc)) 
                                        (List.map fst (Option.get (routeOf lid lc)))
                          )  lc
      Assert.True b

   // more properties can be defined here