module LuggageCatalogueGenerator

open FsCheck

let charGen c1 c2 = Gen.oneof (seq {for c in c1 .. c2 do
                                           yield gen {return c} })

let digitGen = Gen.oneof (seq {for d in 0 .. 9 do 
                                      yield gen {return d}}) 

// Airport ids consist of 3 capital letters
let myAirportGen =    
   gen {let! cs = Gen.listOfLength 3 (charGen 'A' 'Z')
        let ss = List.map string cs
        return String.concat "" ss }

// Flight ids consist of two capital letters and two digits
let myFlightGen =  
   gen {let! cs = Gen.listOfLength 2 (charGen 'A' 'Z')
        let! ds = Gen.listOfLength 2 digitGen  
        let ss = List.map string cs @ List.map string ds
        return String.concat "" ss }

// Lids consist of one small letter and two digits
let myLidGen =  
   gen {let! c  = charGen 'a' 'z'
        let! ds = Gen.listOfLength 2 digitGen  
        let ss = List.map string ds
        return String.concat "" ((string c) ::ss) }

// Routes can have lengths between 1 and 4
let myRouteGen = 
   gen {let! i   = Gen.choose (1,4)
        let! fs  = Gen.listOfLength i myFlightGen
        let! aps = Gen.listOfLength i myAirportGen  
        return List.zip fs aps}
        
// A luggage catalogue can have 0 to 6 entries
let myLugCatGen  = 
       gen { let! i    = Gen.choose (0, 6)
             let! lids = Gen.listOfLength i myLidGen
             let! rs   = Gen.listOfLength i myRouteGen
             return List.zip lids rs      }

type MyLuggageGenerator =
   static member LuggageCatalogue = Arb.fromGen myLugCatGen