﻿// Michael R. Hansen  28-10-2024
module Luggage

type Lid     = string 
type Flight  = string 
type Airport = string

type Route    = (Flight * Airport) list

type  LuggageCatalogue = (Lid * Route) list 


let rec inRoute f = function
                    | []           -> false               // c1
                    | (f1,_)::rest -> if f=f1             // c2
                                      then true     
                                      else inRoute f rest 

(* An erronuous and weird "solution":             *)

let rec withFlight f = 
   function 
   | [(lid, (f1,_)::_)] when f=f1     -> [lid]
   | [(lid, _::rest)]                 -> withFlight f [(lid,rest)] 
   | (lid, (f1,_)::_)::rest when f=f1 -> lid::withFlight f rest
   | (_,[])::rest                     -> withFlight f rest
   | _                                -> [""]

(* A well-designed implementation *)
(* 
let rec withFlight f = 
   function
   | []                           -> []
   | (lid,r)::lc when inRoute f r -> lid ::withFlight f lc
   | _::lc                        -> withFlight f lc
*)

let rec routeOf lid = 
   function 
   | []                        -> None
   | (lid',r)::_ when lid=lid' -> Some r
   | _::rest                   -> routeOf lid rest  